package jamezo97.clonecraft.Synchronize;

import jamezo97.clonecraft.Logger;

import java.util.ArrayList;
import java.util.HashMap;

public class SyncData {
	
	public int channel;
	
	public HashMap<Integer, Object> idToValue = new HashMap<Integer, Object>();
	
	public ArrayList<Integer> ids = new ArrayList<Integer>();
	
	public SyncData(int channel){
		this.channel = channel;
	}
	
	public void addData(int id, Object value){
		idToValue.put(id, value);
		if(!ids.contains(id)){
			ids.add(id);
		}
	}

	public SyncData importValues(int[] ids, Object[] values) {
		if(ids.length != values.length){
			Logger.error("You screwed that up pretty well. SyncData value lengths are not equal when importing.");
			return this;
		}
		for(int a = 0; a < ids.length; a++){
			addData(ids[a], values[a]);
		}
		return this;
	}

}
